/*
** bitmap.h --- generic bitmap operations
*/
#ifndef BITMAP_H
#define BITMAP_H

Inline void
bitmap_setbit( byte *bmp, uint i )
{
  bmp[i/8] |= BV(i%8);
}

Inline void
bitmap_clrbit( byte *bmp, uint i )
{
  bmp[i/8] &= ~BV(i%8);
}

Inline bool
bitmap_getbit( byte *bmp, uint i )
{
  return (bmp[i/8] & BV(i%8));
}

Inline int
bitmap_bitfind_1( byte *bmp, uint byte_count )
{
  static const int qfind[16] = {-1,0,1,0, 2,0,1,0, 3,0,1,0, 2,0,1,0};
  int i;

  for( i = 0 ; i < byte_count ; i++, bmp++ )
    {
      if( *bmp == 0 )
	continue;
      if( (*bmp) & 0xf )
	return qfind[(*bmp) & 0xf] + i*8;
      if( ((*bmp) >> 4) & 0xf )
	return qfind[((*bmp) >> 4) & 0xf] + 4 + i*8;
    }
  return -1;
}

Inline int
bitmap_bitcount_1( byte *bmp, uint byte_count )
{
  static const int qcnt[16] = {0,1,1,2, 1,2,2,3, 1,2,2,3, 2,3,3,4};
  uint i, sum;

  sum = 0;
  for( i = 0 ; i < byte_count ; i++, bmp++ )
    {
      if( *bmp == 0 )
	continue;
      sum += qcnt[(*bmp) & 0xf] + qcnt[((*bmp) >> 4) & 0xf];
    }
  return sum;
}

#endif /* BITMAP_H */
