/*
** buffer.h --- ring buffer
*/
#ifndef BUFFER_H
#define BUFFER_H

typedef struct {
  byte *buf;
  uint bufsize;
  uint head;
  uint size;
} Buffer;

void buffer_init( Buffer *buffer, void *buf, uint bufsize );
Eint buffer_push( Buffer *buffer, void *ptr, uint count );
Eint buffer_poll( Buffer *buffer, void *ptr, uint count );
Eint buffer_look( Buffer *buffer, void *ptr, uint count );

Inline void
buffer_clear( Buffer *buffer )
{
  buffer->head = 0;
  buffer->size = 0;
}

Inline Eint
buffer_getc( Buffer *buffer )
{
  uint seek = buffer->head;

  if( buffer->size == 0 )
    return -1;

  buffer->size--;
  buffer->head++;
  buffer->head %= buffer->bufsize;
  return buffer->buf[seek];
}

Inline Eint
buffer_putc( Buffer *buffer, int ch )
{
  if( buffer->size + 1 > buffer->bufsize )
    return -1;

  buffer->buf[buffer->head + buffer->size] = ch;
  buffer->size++;
  return 0;
}

#endif /* BUFFER_H */
