/*
** debug.h --- debug support utilities
*/
#ifndef DEBUG_H
#define DEBUG_H

Inline void
dump( void *ptr, uint size )
{
  byte *p = (byte*)ptr;
  uint i;

  for( i = 0 ; i < size ; i++ )
    {
      if( i % 16 == 0 )
	{
	  printk("\n%x: ", &(p[i]));
	}
      printk("%02x ", p[i]);
    }
  printk("\n");
}

Inline void
stack_dump( void *esp, int count )
{
  word32 *stack = esp;
  int i;

  for( i = 0 ; i < count ; i++ )
    {
      printk("\n%x: %08x", &(stack[i]), stack[i]);
    }
  printk("\n");
}

#endif /* DEBUG_H */
