/*
** dev.h --- device interface
*/
#ifndef DEV_H
#define DEV_H

/* device major number */
enum {
  DEV_CONSOLE	= 0x01,
  DEV_FLOPPY	= 0x81,
  DEVNUM = 256,
};

typedef struct device_operation_t {
  Err (*setup)(void);
  Err (*init)( void *arg );
  Eint (*open)( byte minor, void *arg );
  Err (*close)( byte minor );
  Eint (*read)( byte minor, void *buf, uint count );
  Eint (*write)( byte minor, void *buf, uint count );
  Eint (*lseek)( byte minor, int offset, int whence );
  Eint (*ioctl)( byte minor, int request, void *arg );
  Eint (*select)( byte minor, int type, int wait );
} device_operation_t;

void setup_dev(void);
Err init_dev( byte major, void *arg );
Eint open_dev( byte major, byte minor, void *arg );
Err close_dev( int id );
Eint read_dev( int id, void *buf, uint count );
Eint write_dev( int id, void *buf, uint count );
Eint lseek_dev( int id, int offset, int whence );
Eint ioctl_dev( int id, int request, void *arg );
Eint select_dev( int id, int type, int wait );

#endif /* DEV_H */
