/*
** list.h --- double linked list
*/
#ifndef LIST_H
#define LIST_H

typedef struct List {
  struct List *prev, *next;
} List;

#define init_list(head)\
	{(head)->prev = (head)->next = (head);}

#define isempty_list(head)\
	((head)->next == (head))

#define add_list(head, new)\
	{\
	  (new)->next = (head)->next;\
	  (new)->prev = (head);\
	  (head)->next->prev = (new);\
	  (head)->next = (new);\
	}

#define add_list_tail(head, new)\
	{\
	  (new)->next = (head);\
	  (new)->prev = (head)->prev;\
	  (head)->prev->next = (new);\
	  (head)->prev = (new);\
	}

#define del_list(i)\
	{\
	  (i)->prev->next = (i)->next;\
	  (i)->next->prev = (i)->prev;\
	  (i)->prev = (i)->next = (i);\
	}

#define foreach_list( head, item )\
  for( (item) = (head)->next; (item) != (head); (item) = (item)->next )

/* safe to delete an item inner this loop */
#define foreach_list_delsafe( head, item, n )\
  for( (item) = (head)->next, n = (item)->next; (item) != (head);\
       (item) = n, n = (item)->next )

#define reveach_list( head, item )\
  for( (item) = (head)->prev; (item) != (head); (item) = (item)->prev )

/* safe to delete an item inner this loop */
#define reveach_list_delsafe( head, item, p )\
  for( (item) = (head)->prev, p = (item)->prev; (item) != (head);\
       (item) = p, p = (item)->prev )

#endif /* LIST_H */
