/*
** splist.h --- single pointer stack list
*/
#ifndef SPLIST_H
#define SPLIST_H

#define next_splist(head)	(*(pointer*)(head))
#define init_splist(head)	{next_splist(head) = NULL;}
#define isempty_splist(head)	(next_splist(head))

Inline void
push_splist( pointer head, pointer new )
{
  next_splist(new) = next_splist(head);
  next_splist(head) = new;
}

Inline pointer
pop_splist( pointer head )
{
  pointer out;
  out = next_splist(head);
  if( out )
    next_splist(head) = next_splist(out);
  return out;
}

#define foreach_splist(head, item)\
  for( (item) = next_splist(head); (item) != NULL; (item) = next_splist(item) )

#endif /* SPLIST_H */
