/*
** task.h --- task scheduler
*/
#ifndef TASK_H
#define TASK_H

#include <desc.h>
#include <memory.h>

#define IOENABLE_SIZE 33
#define IOBASE	(sizeof(TSS)-IOENABLE_SIZE)

typedef struct TSS {
  word16 back,	r0;
  word32 esp0;
  word16 ss0,	r1;
  word32 esp1;
  word16 ss1,	r2;
  word32 esp2;
  word16 ss2,	r3;
  word32 cr3;
  word32 eip;
  word32 eflags;
  word32 eax;
  word32 ecx;
  word32 edx;
  word32 ebx;
  word32 esp;
  word32 ebp;
  word32 esi;
  word32 edi;
  word16 es,	r4;
  word16 cs,	r5;
  word16 ss,	r6;
  word16 ds,	r7;
  word16 fs,	r8;
  word16 gs,	r9;
  word16 ldt,	rA;
  word16 trap,	iobase;
  byte ioenable[IOENABLE_SIZE];
} TSS;

enum task_state {
  TASK_IDLE	= 0x00,
  TASK_READY	= 0x01,
  TASK_EXIT	= 0x80,
  TASK_WAIT	= 0x81,
};

typedef struct Taskinfo {
  uint id;
  bool user;
  uint code_head, code_size;
  uint data_head, data_size;
  uint bss_head, bss_size;
  uint stack_tail, stack_size;
  uint arg_head, arg_size;
  uint env_head, env_size;
  uint pgd;
} Taskinfo;

typedef struct Task {
  struct Task *prev, *next;
  uint state;
  void (*wait_poll)( struct Task *task, void *wait_info );
  void *wait_info;
  Taskinfo info;
  uint brk_start_page;
  uint brk_pages;
  sdesc_t tss_desc;
  TSS tss;
} Task;

extern bool enable_dispatch;

void setup_task(void);
Task *create_task( Taskinfo *info );
void destroy_task( Task *task );
void dispatch(void);
void wait_task( Task *task, void (*wait_poll)(Task*, void*), void *wait_info );
void weakup_task( Task *task );
void exit_task( Task *task );
Err brk_task( Task *task, uint size );

void wait( void (*wait_poll)(Task*, void*), void *wait_info );
void sleep( uint seconds );
void usleep( uint usec );
void exit(void);
Err brk( uint size );

#endif /* TASK_H */
