/*
** syslog.c --- system log
*/

#include <coron.h>
#include <stdarg.h>
#include <string.h>
#include <buffer.h>

enum{ SYSLOG_BUFSIZE = 8192 };
static Buffer syslog_buffer;
static byte syslog_buf[SYSLOG_BUFSIZE];

static void (*putc_syslog)( int c );

static void
flush_syslog(void)
{
  BEGIN_CPULOCK

  int ch;
  if( putc_syslog )
    {
      while( (ch = getc_syslog()) >= 0 )
	putc_syslog( ch );
    }
  
  END_CPULOCK
}

void
setup_syslog(void)
{
  buffer_init( &syslog_buffer, syslog_buf, sizeof(syslog_buf) );
  putc_syslog = NULL;
}

void
set_syslog_putc( void (*putc)(int c) )
{
  putc_syslog = putc;
  flush_syslog();
}

void
printk( const char *fmt, ... )
{
  va_list ap;
  byte buf[512];

  va_start( ap, fmt );
  vsnprintf( buf, sizeof(buf), fmt, ap );
  buffer_push( &syslog_buffer, buf, strlen(buf) );
  flush_syslog();

  va_end(ap);
}

void
panic( const char *fmt, ... )
{
  va_list ap;
  byte buf[512];

  va_start( ap, fmt );
  vsnprintf( buf, sizeof(buf), fmt, ap );
  buffer_push( &syslog_buffer, buf, strlen(buf) );
  panic_system();
  flush_syslog();

  va_end(ap);
}

Eint
getc_syslog(void)
{
  return buffer_getc( &syslog_buffer );
}
