/*
** buddy.c --- 르ꥺ(buddy algorithm)Ȥä
*/

#include <coron.h>
#include <bitmap.h>
#include <string.h>
#include <debug.h>
#include "buddy.h"

/*
 * ΥǶ(ӥåȣ)õ
 * ʤ 0 ֤
 */
static uint
map_search( byte *map, uint l_order )
{
  uint found;
  int b;

  found = 0;
  switch( l_order )
    {
    case 0:
      if( bitmap_getbit(map, 1) )
	found = 1;
      break;
    case 1:
      if( bitmap_getbit(map, 2) )
	found = 2;
      ef( bitmap_getbit(map, 3) )
	found = 3;
      break;
    case 2:
      if( bitmap_getbit(map, 4) )
	found = 4;
      ef( bitmap_getbit(map, 5) )
	found = 5;
      ef( bitmap_getbit(map, 6) )
	found = 6;
      ef( bitmap_getbit(map, 7) )
	found = 7;
      break;
    default:
      map += BV(l_order) / 8;
      b = bitmap_bitfind_1( map, BV(l_order) / 8 );
      if( b >= 0 )
	found = b + BV(l_order);
      break;
    }

  CHECK_ABORT( found == 0 ||
	       (BV(l_order) <= found && found < BV(l_order)*2),
	       "invalid found=%d, l_order=%d", found, l_order );
  return found;
}

/*
 * ӥåȥޥåפΥΰݤ
 * l_order = buffer->order - order
 */
static uint
map_alloc( byte *map, uint l_order )
{
  uint p, found;

  found = map_search( map, l_order );
  if( found == 0 )
    {
      if( l_order == 0 )
	return 0;

      p = map_alloc( map, l_order - 1 );
      if( p == 0 )
	return 0;

      bitmap_setbit( map, p*2 );
      found = p*2+1;
    }
  bitmap_clrbit( map, found );
  return found;
}

static uint
map_fixed_alloc( byte *map, uint i )
{
  uint p;

  if( i == 0 )
    return 0;

  if( bitmap_getbit(map, i) == 0 )
    {
      p = map_fixed_alloc( map, i/2 );
      if( p == 0 )
	return 0;

      bitmap_setbit( map, i^1 );
    }

  bitmap_clrbit( map, i );
  return i;
}

static void
map_free( byte *map, uint i )
{
  if( i == 0 )
    return;

  if( bitmap_getbit(map, i^1) )
    {
      bitmap_clrbit(map, i^1);
      map_free(map, i/2);
    }
  else
    bitmap_setbit(map, i);
}

/*
 * 2 ** order ڡΰ BuddyƥΰȤƽ롣
 * map ˤ (2 ** order) * 2 / 8 Хȡ
 * mem ˤ 2 ** order ڡΰ褬ɬ
 */
void
buddy_init( Buddy *buddy, uint order, void *map, void *mem )
{
  memset( map, 0, BV(order)*2/8 );
  bitmap_setbit( map, 1 );
  buddy->map   = map;
  buddy->mem   = mem;
  buddy->order = order;
  buddy->rest  = BV(order);
}

/*
 * 2 ** order ڡΰݤ
 */
void *
buddy_alloc( Buddy *buddy, uint order )
{
  uint found, offset;

  CHECK_ABORT( order <= buddy->order,
	       "invalid order %d <= %d", order, buddy->order );

  if( buddy->rest < BV(order) )
    return NULL;

  found = map_alloc( buddy->map, buddy->order - order );
  if( found == 0 )
    return NULL;

  buddy->rest -= BV(order);
  offset = (found - BV(buddy->order - order)) * BV(order);
  return buddy->mem + offset * PAGE_SIZE;
}

void *
buddy_fixed_alloc( Buddy *buddy, uint order, void *ptr )
{
  uint i, offset;

  CHECK_ABORT( buddy->mem <= ptr &&
	       ptr < buddy->mem + BV(buddy->order) * PAGE_SIZE,
	       "invalid pointer %x", (int)ptr );

  if( buddy->rest < BV(order) )
    return NULL;

  offset = (ptr - buddy->mem) / PAGE_SIZE;
  i = offset / BV(order) + BV(buddy->order - order);
  if( map_fixed_alloc(buddy->map, i) == 0 )
    return 0;

  buddy->rest -= BV(order);
  return ptr;
}

/*
 * buddy_alloc Ǽΰ롣
 * buddy_alloc ǻꤷΤƱ order ɬס
 */
void
buddy_free( Buddy *buddy, uint order, void *ptr )
{
  uint i, offset;

  CHECK_ABORT( buddy->mem <= ptr &&
	       ptr < buddy->mem + BV(buddy->order) * PAGE_SIZE,
	       "invalid pointer %x", (int)ptr );

  CHECK_ABORT( buddy->rest + BV(order) > BV(buddy->order),
	       "invalid free" );

  offset = (ptr - buddy->mem) / PAGE_SIZE;
  i = offset / BV(order) + BV(buddy->order - order);
  map_free( buddy->map, i );
  buddy->rest += BV(order);
}
