/*
** buffer.c --- ring buffer
*/

#include <coron.h>
#include <buffer.h>

void
buffer_init( Buffer *buffer, void *buf, uint bufsize )
{
  buffer->buf = buf;
  buffer->bufsize = bufsize;
  buffer->head = 0;
  buffer->size = 0;
}

Eint
buffer_push( Buffer *buffer, void *ptr, uint count )
{
  byte *buf = buffer->buf;
  uint seek = buffer->head + buffer->size;
  byte *p = (byte*)ptr;
  uint i;

  if( buffer->size + count > buffer->bufsize )
    return -1;

  for( i = 0 ; i < count ; i++ )
    {
      buf[seek++] = *p++;
      seek %= buffer->bufsize;
    }
  buffer->size += count;
  return count;
}

Eint
buffer_poll( Buffer *buffer, void *ptr, uint count )
{
  byte *buf = buffer->buf;
  uint seek = buffer->head;
  byte *p = (byte*)ptr;
  uint i;

  if( buffer->size < count )
    return -1;

  for( i = 0 ; i < count ; i++ )
    {
      *p++ = buf[seek++];
      seek %= buffer->bufsize;
    }
  buffer->head = seek;
  buffer->size -= count;
  return count;
}

Eint
buffer_look( Buffer *buffer, void *ptr, uint count )
{
  byte *buf = buffer->buf;
  uint seek = buffer->head;
  byte *p = (byte*)ptr;
  uint i;

  if( buffer->size < count )
    return -1;

  for( i = 0 ; i < count ; i++ )
    {
      *p++ = buf[seek++];
      seek %= buffer->bufsize;
    }
  return count;
}
