/*
** test.c --- test application
*/

#include <coron.h>
#include <memory.h>
#include <clock.h>
#include <keyboard.h>
#include <console.h>
#include <task.h>

static byte stack0[1024], stack1[1024], stack2[1024], stack3[1024], stack4[1024];

void test(void);
void task0(void);
void task1(void);
void task2(void);
void task3(void);
void task4(void);

static Taskinfo task[] = {
  {
    0x80, 1,
    (uint)task0, 0,
    0, 0,    0, 0,
    (uint)stack0 + 1024, 1024,
    0, 0,    0, 0,
    0,
  },
  {
    0x81, 1,
    (uint)task1, 0,
    0, 0,    0, 0,
    (uint)stack1 + 1024, 1024,
    0, 0,    0, 0,
    0,
  },
  {
    0x82, 1,
    (uint)task2, 0,
    0, 0,    0, 0,
    (uint)stack2 + 1024, 1024,
    0, 0,    0, 0,
    0,
  },
  {
    0x83, 1,
    (uint)task3, 0,
    0, 0,    0, 0,
    (uint)stack3 + 1024, 1024,
    0, 0,    0, 0,
    0,
  },
  {
    0x84, 1,
    (uint)task4, 0,
    0, 0,    0, 0,
    (uint)stack4 + 1024, 1024,
    0, 0,    0, 0,
    0,
  },
};

void
task0(void)
{
  unlock_cpu();
  for(;;)
    {
      usleep(100*1000);
      kputc('_');
    }
  exit();
}

void
task1(void)
{
  unlock_cpu();
  for(;;)
    {
      sleep(1);
      kputc('1');
    }
  exit();
}

void
task2(void)
{
  unlock_cpu();
  sleep(2);
  kputc('2');
  create_task( &(task[3]) );
  exit();
}

void
task3(void)
{
  unlock_cpu();
  sleep(3);
  kputc('3');
  create_task( &(task[2]) );
  exit();
}

void
task4(void)
{
  char ch;
  unlock_cpu();

  kprintf("\n(task4): please push any key...\n");
  for(;;)
    {
      ch = getc_current_console();
      if( ch )
	kprintf("<%c>", ch);
    }
}

void
setup_test(void)
{
  kputs("Testing for task management\n"
	"_: (task0) sleep 0.1sec cycle\n"
	"1: (task1) sleep 1sec cycle\n"
	"2: (task2) sleep 2sec cycle create (task3) and exit\n"
	"3: (task3) sleep 3sec cycle create (task2) and exit\n"
	"4: (task4) testing for keyboard\n"
	"Ready GO!\n");

  task[0].pgd = (uint)system_pgd;
  task[1].pgd = (uint)system_pgd;
  task[2].pgd = (uint)system_pgd;
  task[3].pgd = (uint)system_pgd;
  task[4].pgd = (uint)system_pgd;
  create_task( &(task[0]) );
  create_task( &(task[1]) );
  create_task( &(task[2]) );
  create_task( &(task[4]) );
}
