/*
** boot.c --- boot loader
*/

/* startup code */
asm(
".text				\n"
".code16gcc			\n"
"	ljmp $0, $start		\n"
"start:				\n"
"	cli			\n"
"	mov	%cs, %ax	\n"
"	mov	%ax, %ds	\n"
"	mov	%ax, %es	\n"
"	mov	%ax, %ss	\n"
"	mov	$0x3f00, %sp	\n" // mov $(MEM_ZONE-0x100), %sp
"	sti			\n"
"	call	boot		\n"
"dead:	jmp	dead		\n"
);

#include <coron.h>
#include <bootinfo.h>

/* boot information inner IPL */
static Bootinfo info __SECTION__(".info");

Inline int
reset_drive( byte drive )
{
  int ret;
  Asm("int $0x13": "=a"(ret): "a"(0), "d"(drive));
  return ((ret >> 8) & 0xff);
}

Inline int
read_drive( byte drive, void* buf, uint sec )
{
  int ret;
  Asm("int $0x13": "=a"(ret):
      "a"(0x201), "b"(buf),
      "c"( ((sec/SECPTRK/2) << 8) | (sec%SECPTRK+1) ),
      "d"( (((sec/SECPTRK)%2) << 8) | drive) );
  return ((ret >> 8) & 0xff);
}

void
puts( char *msg )
{
  char c;
  while((c = *msg++))
    Asm("int $0x10":: "a"(0x0e00|c), "b"(7));
}

void
boot(void)
{
  int i;
  puts("boot:");

  /* load setup program */
  if( reset_drive(info.boot_drive) )
    goto load_error;

  for( i = 0 ; i < info.setup_count ; i++ )
    {
      puts(".");
      if( read_drive(info.boot_drive,
		     (void*)(MEM_SETUP + i * SECSIZE), info.setup_head + i) )
	goto load_error;
    }
  puts("ok\r\n");

  /* activate setup */
  Asm("ljmp $0, %0"::"i"(MEM_SETUP));

 load_error:
  puts("error");
  return;
}
