/*
** bootinfo.h --- boot information
*/
#ifndef BOOTINFO_H
#define BOOTINFO_H

enum {
  SECSIZE = 512,
  SECPTRK = 18,
  TRKSIZE = SECPTRK*SECSIZE,
};

typedef struct {
  /* IPL information */
  uint boot_drive;
  uint setup_head;
  uint setup_count;
  uint kernel_head;
  uint kernel_count;
  uint kernel_size;

  /* setup information */
  uint extmem_size;
} Bootinfo;

#endif /* BOOTINFO_H */
