/*
** clock.c --- system clock using i8254
*/

#include <coron.h>
#include "irq.h"
#include "intr.h"
#include "clock.h"
#include "task.h"

/* i8254 registers */
enum {
  CN0 = 0x40,
  CN1 = 0x41,
  CN2 = 0x42,
  CTL = 0x43,
};

/* i8254 counts for system clock cycle */
static const uint COUNT = 1193182 / CLOCK_PER_SEC;

/* system clock counter */
static uint sys_clock;

INTERRUPT(do_clock);
void
do_clock(void)
{
  disable_irq(IRQ_PIT);
  sys_clock++;
  next_irq(IRQ_PIT);
  if( enable_dispatch )
    dispatch();
}

uint
get_clock(void)
{
  return sys_clock;
}

void
setup_clock(void)
{
  /* initializing i8254 */
  outb( CTL, 0x36 );
  outb( CN0, COUNT & 0xff );
  outb( CN0, COUNT >> 8 );

  /* reset system clock counter */
  sys_clock = 0;

  /* setup clock interrupt handler */
  define_intr( IRQ_TO_INTN(IRQ_PIT), INTR_ENTRY(do_clock) );
  enable_irq( IRQ_PIT );
}
