/*
** config_bootinfo.c --- configuration tool for boot information structure
*/

#include <stdio.h>
#include <stdlib.h>
#include "config.h"
#include "bootinfo.h"

void
usage(void)
{
  puts("Usage: config_bootinfo BOOT_DRIVE SETUP_HEAD KERNEL_HEAD BOOT.BIN SETUP.BIN KERNEL.BIN\n");
}

int
get_filesize( const char *path )
{
  FILE *file;
  int size;

  file = fopen(path, "rb");
  if( file == NULL )
    {
      perror(path);
      return -1;
    }
  fseek(file, 0, SEEK_END);
  size = ftell(file);
  fclose(file);
  return size;
}

int
write( const char *path, int offset, void *ptr, int size )
{
  FILE *file;

  file = fopen(path, "r+b");
  if( file == NULL )
    {
      perror(path);
      return -1;
    }
  fseek(file, offset, SEEK_SET);
  fwrite(ptr, 1, size, file);
  fclose(file);
  return 0;
}

int
main( int argc, char *argv[] )
{
  Bootinfo info;
  char *boot, *setup, *kernel;
  int setup_size, kernel_size;

  if( argc != 7 )
    goto error;

  info.boot_drive   = atoi(argv[1]);
  info.setup_head   = atoi(argv[2]);
  info.kernel_head  = atoi(argv[3]);

  boot   = argv[4];
  setup  = argv[5];
  kernel = argv[6];

  /* get setup and kernel size */
  setup_size = get_filesize( setup );
  kernel_size = get_filesize( kernel );
  if( setup_size < 0 || kernel_size < 0 )
    goto error;

  info.setup_count  = setup_size / SECSIZE + 1;
  info.kernel_count = kernel_size / SECSIZE + 1;
  info.kernel_size  = kernel_size;

  /* write boot information */
  if( write(boot, MEM_IPLINFO-MEM_IPL, &info, sizeof(info)) < 0 )
    goto error;

  return 0;

 error:
  usage();
  return 1;
}

