/*
** dma.h --- DMA controller
*/
#ifndef DMA_H
#define DMA_H

/* transfer type */
enum {
  DMA_VERIFY = 0,
  DMA_IOWRITE = 1,
  DMA_IOREAD = 2,
};

/* mode type */
enum {
  DMA_DEMAND = 0,
  DMA_SINGLE = 1,
  DMA_BLOCK = 2,
};

void setup_dma(void);
void enable_dma( byte channel );
void disable_dma( byte channel );
void set_dma_area( byte channel, uint dma_addr, uint dma_count );
void set_dma_mode( byte channel, byte trans, byte mode, bool autoinit );

#endif /* DMA_H */
