/*
** intr.c --- interrupt handling
*/

#include <coron.h>
#include "desc.h"
#include "irq.h"
#include "intr.h"
#include "excp.h"

void
setup_intr(void)
{
}

void
define_intr( uint n, uint addr )
{
  BEGIN_CPULOCK

  gdesc_t *idt = (void*)MEM_IDT;
  set_gdesc( &idt[n], GDT_KERNEL_CODE, addr, GATE_INTR32, 0 );

  END_CPULOCK
}
