/*
** intr.h --- interrupt handling
*/
#ifndef INTR_H
#define INTR_H

/* entry definition of an interrupt call handler */
#define INTERRUPT( func )\
extern void func##_interrupt(void);\
asm(\
".text				\n"\
#func"_interrupt:               \n"\
"       pusha                   \n"\
"       call    "#func"         \n"\
"       popa                    \n"\
"       iret                    \n")

#define EXCEPTION( func )\
extern void func##_exception(void);\
asm(\
".text				\n"\
#func"_exception:               \n"\
"	pusha			\n"\
"	push	%ss		\n"\
"	push	%ds		\n"\
"	push	%es		\n"\
"	push	%fs		\n"\
"	push	%gs		\n"\
"	call	"#func"         \n"\
"	pop	%gs		\n"\
"	pop	%fs		\n"\
"	pop	%es		\n"\
"	pop	%ds		\n"\
"	pop	%ss		\n"\
"	popa			\n"\
"	iret			\n")

/* get entry address of an interrupt call handler */
#define INTR_ENTRY( func )      ((uint)func##_interrupt)
#define EXCP_ENTRY( func )      ((uint)func##_exception)

void setup_intr(void);
void define_intr( uint n, uint addr );

#endif /* INTR_H */
