/*
** irq.h --- interrupt request management
*/
#ifndef IRQ_H
#define IRQ_H

/* IRQ numbers */
enum {
  IRQBASE  = 0x20,
  IRQBASE8 = 0x28,
  IRQ_PIT  = 0,
  IRQ_KBC  = 1,
  IRQ_FDC  = 6,
  IRQ_RTC  = 8,
  IRQ_FPU  = 13,
  IRQ_IDE0 = 14,
  IRQ_IDE1 = 15,
};

#define IRQ_TO_INTN(irq) (IRQBASE + (irq))

void setup_irq(void);
void eoi_irq( uint irq );
void disable_irq( uint irq );
void enable_irq( uint irq );

Inline void
next_irq( uint irq )
{
  eoi_irq(irq);
  enable_irq(irq);
}

#endif /* IRQ_H */
