/*
** memory.h --- $B%a%b%j4IM}(B
*/
#ifndef MEMORY_H
#define MEMORY_H

/* page table entry */
typedef struct {
  unsigned p:1;		/* present */
  unsigned rw:1;	/* read/write */
  unsigned us:1;	/* user/supervisor */
  unsigned pwt:1;	/* page write through (after i486) */
  unsigned pcd:1;	/* page cache disable (after i486) */
  unsigned a:1;		/* access */
  unsigned d:1;		/* dirty */
  unsigned ps:1;	/* page size (0 for 4KB) */
  unsigned g:1;		/* global page (after i686) */
  unsigned map:1;	/* system bit 0 (mapped check) */
  unsigned os1:1;	/* system bit 1 */
  unsigned os2:1;	/* system bit 2 */
  unsigned page:20 __PACKED__;	/* physical page number */
} PTE;

typedef struct {
  int objsize;
  int objcount;
  pointer slab_ptr;
} Cache;

/* system page directory */
extern PTE *system_pgd;

void setup_memory(void);
void *alloc_page(void);
void free_page( void *p );
void *alloc_vpage( PTE *pgd, uint vpage, bool writable, bool user );
void free_vpage( PTE *pgd, uint vpage );
void *map_vpage( PTE *pgd, uint vpage, uint page, bool writable, bool user );
void *unmap_vpage( PTE *pgd, uint vpage );
void map_vmem( PTE *pgd, uint page, uint count, bool writable, bool user );
void unmap_vmem( PTE *pgd, uint page, uint count );
int get_freepage_count(void);
int get_memory_pages();

void create_cache( Cache *cache, int objsize );
void *alloc_cache( Cache *cache );
void free_cache( Cache *cache, void *obj );

#endif /* MEMORY_H */
