/*
** system.c --- system operations
*/

/* startup code */
asm(
".text				\n"
"	mov	$0x18, %eax	\n" // mov $GDT_KERNEL_DATA, %eax
"	mov	%eax, %ds	\n"
"	mov	%eax, %es	\n"
"	mov	%eax, %fs	\n"
"	mov	%eax, %gs	\n"
"	mov	%eax, %ss	\n"
"	call	start		\n"
"dead:	jmp	dead		\n"
);

#include <coron.h>
#include <bootinfo.h>
#include <string.h>

#include <irq.h>
#include <intr.h>
#include <excp.h>
#include <clock.h>
#include <memory.h>
#include <dma.h>

#include <keyboard.h>
#include <console.h>
#include <floppy.h>

#include <task.h>
#include <ksh.h>

void
reboot_system(void)
{
  send_keyboard_reboot();
  lock_cpu();
  halt_cpu();
}

void
panic_system(void)
{
  set_keyboard_leds( MNUM | MSCR );
  lock_cpu();
  halt_cpu();
}

void
putc_system( int c )
{
  putc_console( 0, c );
}

int
getc_system(void)
{
  return getc_console( 0 );
}

void
start(void)
{
  /* setup core modules */
  setup_syslog();
  setup_irq();
  setup_intr();
  setup_excp();
  setup_clock();
  setup_memory();
  setup_dma();
  
  /* setup system console */
  setup_console();
  open_console( 0 );
  set_syslog_putc( putc_system );

  /* starting message */
  printk("Coron de SOS\n");
  printk("mem %dKB / %dKB\n",
	 get_freepage_count() * PAGE_SIZE/1024,
	 get_memory_pages() * PAGE_SIZE/1024 );

  /* setup devices */
  setup_floppy();

  /* setup task */
  setup_task();
  setup_ksh();

  /* start system */
  enable_nmi();
  for(;;)
    {
      lock_cpu();
      dispatch();
      unlock_cpu();
      halt_cpu();
    }
}
