/*
** vgafb.h --- VGA frame buffer device
*/
#ifndef VGAFB_H
#define VGAFB_H

/* ioctl requests */
enum {
  SET_PLANE,
  GET_PLANE,
  GET_WIDTH,
  GET_HEIGHT,
  GET_DEPTH,
  SET_OLDFONT,
  GET_OLDFONT,
  SET_OLDTEXT,
  GET_OLDTEXT,
  GET_PALNUM,
  SET_PALLETS,
  GET_PALLETS,
};

/* screen size */
enum {
  VGAFB_WIDTH  = 640,
  VGAFB_HEIGHT = 480,
  VGAFB_DEPTH  = 4,
  VGAFB_PALNUM = 16,
};

typedef struct {
  byte r, g, b, a;
} Pallet;

Err setup_vgafb( void *arg );
Err release_vgafb(void);
Err open_vgafb( int id );
Err close_vgafb( int id );
Eint read_vgafb( int id, void *buf, uint count );
Eint write_vgafb( int id, void *buf, uint count );
Eint lseek_vgafb( int id, int offset, int whence );
Eint ioctl_vgafb( int id, int request, void *arg );

Eint set_vgafb_plane( uint plane );
Eint get_vgafb_plane(void);
Eint get_vgafb_width(void);
Eint get_vgafb_height(void);
Eint get_vgafb_depth(void);
Eint set_vgafb_oldfont( void *buf );
Eint get_vgafb_oldfont( void *buf );
Eint set_vgafb_oldtext( void *buf );
Eint get_vgafb_oldtext( void *buf );
Eint get_vgafb_palnum(void);
Eint set_vgafb_pallets( Pallet *buf );
Eint get_vgafb_pallets( Pallet *buf );

extern Device vgafb_device;

#endif /* VGAFB_H */
