#!/usr/bin/perl
@POW2 = (1, 2, 4, 8, 16, 32, 64, 128, 256, 512, 1024, 2048, 4096, 8192, 16384, 32768, 65536, 131072, 262144, 524288, 1048576, 
 2097152, 4194304, 8388608, 16777216, 33554432, 67108864, 134217728, 268435456, 536870912, 1073741824, 2147483648, 4294967296);

sub n2bit {
  local($i) = shift;
  local($r) = "";
  while($i > 0){
     $r = ($i%2).$r;
     $i = int($i/2);
  }
  return sprintf("%08d", $r);
}

sub a2bit {
  local($a) = shift;
  local($r);
  while($a =~ /([0-9]+)(.*)/){
#    print STDERR "$a\n";
    $a = $2;
    $r = $r.&n2bit($1);
  }
  return $r;
}

sub net2bit {
  local($a) = shift;
  if($a =~ /([0-9\.]+)\/(.*)/){
     local($x) = $1; local($y) = $2;
     return substr(&a2bit($x), 0, $y)
  }

}

#################
$MASKFILE = shift;
#$TESTFILE = shift;
@MASKS = ();
open(IN, "< $MASKFILE");
while(<IN>){
  if(!/^#/ && /([0-9]+\.[0-9]+\.[0-9]+\.[0-9\.]+)\/([0-9]+)/){
   	local($ip) = $1;
  	local($n) = $2;   
  	print STDERR "PUSH:$ip/$n -> ".&net2bit("$ip/$n")."\n";
  	push(@MASKS, &net2bit("$ip/$n"));

  }
}
sub testmask {
  local($t) = shift;
  local($n);
  for $n (@MASKS){
    if(substr($t, 0, length($n)) eq $n){
       return $n;
    }
  }
  return ;
}
while(<>){
  local($t) = "";
  if(/ipv4\|([0-9]+\.[0-9]+\.[0-9]+\.[0-9]+)\|([0-9]+)/){
#    print;
	local($ip) = $1;
  	local($n) = $2;
  	$t = &net2bit("$ip/$n")
  } elsif(/([0-9]+\.[0-9]+\.[0-9]+\.[0-9\.]+)\/([0-9]+)/){
	local($ip) = $1;
  	local($n) = $2;   
  	$t = &net2bit("$ip/$n");
  }
#  print;
  if($t){
    local($r) = testmask($t);
    if($r){ print; print STDERR "$t\t$r\n";}
  }
}
