/*
	MITEC MP-85 Emulator 'eMP-85'

	Author : Takeda.Toshiya
	Date   : 2021.01.19-

	[ display ]
*/

#ifndef _DISPLAY_H_
#define _DISPLAY_H_

#include "../vm.h"
#include "../../emu_template.h"
#include "../device.h"

#define SIG_DISPLAY_SEL		0
#define SIG_DISPLAY_DISP	1

namespace MP85 {
class DISPLAY : public DEVICE
{
private:
	uint8_t led[16];
	uint8_t sel;
	
public:
	DISPLAY(VM_TEMPLATE* parent_vm, EMU_TEMPLATE* parent_emu) : DEVICE(parent_vm, parent_emu)
	{
		set_device_name(_T("Display"));
	}
	~DISPLAY() {}
	
	// common functions
	virtual void initialize();
	virtual void __FASTCALL write_signal(int id, uint32_t data, uint32_t mask);
	bool process_state(FILEIO* state_fio, bool loading);
	
	// unique function
	void draw_screen();
};
}
#endif

