/* Time-stamp: <2009-05-07 21:48:07 shinya> */

#include <stdlib.h>
#include "cue/cue.h"
#include "../src/add.h"

CU_DEF(test_add)
{
  CU_ASSERT_INT_EQUAL(add(1, 2), 3);
  CU_ASSERT_INT_EQUAL(add(2, -3), -1);
}

/* Example assertions */
CU_DEF(test_assertion)
{
  CU_PASS("pass");
  CU_ASSERT_TRUE(1);
  CU_ASSERT_FALSE(0);
  CU_ASSERT_INT_EQUAL(1, 1);
  CU_ASSERT_INT_NOT_EQUAL(0, 1);
  CU_ASSERT_STRING_EQUAL("cue", "cue");
  CU_ASSERT_STRING_NOT_EQUAL("cue", "euc");
  CU_ASSERT_NSTRING_EQUAL("cue", "cue", 3);
  CU_ASSERT_NSTRING_NOT_EQUAL("cue", "euc", 3);
  CU_ASSERT_DOUBLE_EQUAL(1.11, 1.12, 0.05);
  CU_ASSERT_DOUBLE_NOT_EQUAL(1.11, 1.12, 0.005);
}

int
main(int argc, char **argv)
{
  CU_SETUP();

  CU_REGISTER("add", test_add);
  CU_REGISTER("assertion", test_assertion);

  CU_RUN();

  return EXIT_SUCCESS;
}
