/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.trix.cuery.css.AbstractCSSConsumer;
import org.trix.cuery.parser.CueryParser;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.css.sac.CSSException;
import org.w3c.css.sac.CSSParseException;
import org.w3c.css.sac.InputSource;
import org.w3c.css.sac.LexicalUnit;

public class CSSValidator {
    private static final CueryParser PARSER = new CueryParser();

    public CSSParseException[] validate(InputSource source) throws IOException {
        ValidatableConsumer consumer = new ValidatableConsumer();
        PARSER.setDocumentHandler(consumer);
        PARSER.parseStyleSheet(source);
        return consumer.container.toArray(new CSSParseException[consumer.container.size()]);
    }

    private static class ValidatableConsumer
    extends AbstractCSSConsumer {
        private List container = new ArrayList();

        ValidatableConsumer() {
        }

        public void property(String name, LexicalUnit value, boolean important) throws CSSException {
            PropertyDefinition definition = PropertyRegistry.getDefinition(name);
            if (definition == null) {
                this.addError("This property '" + name + "' is not defined.");
                return;
            }
            CSSValue cssValue = CSSUtil.convert(value);
            Map result = definition.parse(cssValue);
            if (result == null) {
                this.addError("This property '" + name + "' has a invalid value. '" + CSSUtil.toString(cssValue) + "'");
                return;
            }
        }

        private void addError(String message) {
            CSSParseException exception = new CSSParseException(message, PARSER.getLocator());
            this.container.add(exception);
        }
    }
}

