/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.CSSException;
import org.w3c.dom.Element;

public abstract class AbstractNumeralFilter
implements Filter {
    protected String argument;
    private int a = 0;
    private int b = 0;

    public AbstractNumeralFilter(String argument) throws CSSException {
        if (argument == null || argument.length() == 0) {
            throw new CSSException("This argument is null.");
        }
        this.argument = argument;
        if (argument.equals("even")) {
            this.a = 2;
            return;
        }
        if (argument.equals("odd")) {
            this.a = 2;
            this.b = 1;
            return;
        }
        int pos = argument.indexOf("n");
        if (pos == -1) {
            try {
                this.b = Integer.parseInt(argument);
            }
            catch (NumberFormatException e) {
                throw new CSSException("This argument format is invalid.");
            }
        } else {
            this.a = this.parseInt(argument.substring(0, pos), 1);
            this.b = this.parseInt(argument.substring(pos + 1), 0);
        }
        if (this.b < 0) {
            throw new CSSException("The argument 'b' must be positive.");
        }
    }

    private int parseInt(String value, int def) {
        if (value == null || value.length() == 0) {
            return def;
        }
        if (value.equals("+")) {
            return 1;
        }
        if (value.equals("-")) {
            return -1;
        }
        if (value.charAt(0) == '+') {
            value = value.substring(1);
        }
        return Integer.parseInt(value);
    }

    public boolean accept(Element target) {
        int position = this.getPosition(target);
        if (position < 1) {
            return false;
        }
        for (int current = this.b; current >= 0; current += this.a) {
            if (current == position) {
                return true;
            }
            if (this.a == 0 || this.a > 0 && current > position || this.a < 0 && current < position) break;
        }
        return false;
    }

    public int getSpecificity() {
        return 10;
    }

    public short getConditionType() {
        return 3;
    }

    public short getSelectorType() {
        return 0;
    }

    protected abstract int getPosition(Element var1);
}

