/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.filter;

import org.trix.cuery.filter.Filter;
import org.w3c.css.sac.CombinatorCondition;
import org.w3c.css.sac.Condition;
import org.w3c.css.sac.ConditionalSelector;
import org.w3c.css.sac.Selector;
import org.w3c.css.sac.SimpleSelector;
import org.w3c.dom.Element;

public class MultipleFilter
implements Filter,
CombinatorCondition,
ConditionalSelector {
    private Filter first;
    private Filter second;

    public MultipleFilter(Filter first, Filter second) {
        this.first = first;
        this.second = second;
    }

    public boolean accept(Element target) {
        return this.first.accept(target) && this.second.accept(target);
    }

    public int getSpecificity() {
        return this.first.getSpecificity() + this.second.getSpecificity();
    }

    public short getConditionType() {
        return 0;
    }

    public short getSelectorType() {
        return 0;
    }

    public Condition getFirstCondition() {
        return this.first;
    }

    public Condition getSecondCondition() {
        return this.second;
    }

    public Condition getCondition() {
        return this.second;
    }

    public SimpleSelector getSimpleSelector() {
        if (this.first instanceof SimpleSelector) {
            return (SimpleSelector)this.first;
        }
        return new SimpleSelectorWrapper(this.first);
    }

    public String toString() {
        return String.valueOf(this.first.toString()) + this.second.toString();
    }

    private static final class SimpleSelectorWrapper
    implements SimpleSelector {
        private Selector selector;

        public SimpleSelectorWrapper(Selector selector) {
            this.selector = selector;
        }

        public short getSelectorType() {
            return this.selector.getSelectorType();
        }

        public String toString() {
            return this.selector.toString();
        }
    }
}

