/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.property;

import java.util.LinkedList;
import org.trix.cuery.property.AbstractProperty;
import org.trix.cuery.property.Property;
import org.trix.cuery.property.PropertyDefinition;
import org.trix.cuery.property.PropertyRegistry;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSValue;
import org.w3c.dom.Element;

public class CascadableProperty
extends AbstractProperty {
    public static final int ORIGIN_AGENT = 1;
    public static final int ORIGIN_USER = 2;
    public static final int ORIGIN_AUTHOR = 3;
    private LinkedList properties = new LinkedList();
    private int author = 0;
    private int user = 0;
    private Element parent;

    public CascadableProperty() {
    }

    public CascadableProperty(Element parent) {
        this.parent = parent;
    }

    public CSSValue getValue(String name) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);
        CSSValue value = this.getSpecifiedValue(definition);
        Property parent = CSSUtil.getProperty(this.parent);
        if (parent == null) {
            return definition.getComputedValue(value, this, RootProperty.SINGLETON);
        }
        return definition.getComputedValue(value, this, parent);
    }

    private CSSValue getSpecifiedValue(PropertyDefinition definition) {
        CSSValue value;
        Property property;
        PropertyWeightSet set;
        String name = definition.getName();
        int i = this.author;
        while (i < this.user) {
            set = (PropertyWeightSet)this.properties.get(i);
            property = set.property;
            if (property.isImportant(name)) {
                return property.getValue(name);
            }
            ++i;
        }
        i = 0;
        while (i < this.author) {
            set = (PropertyWeightSet)this.properties.get(i);
            property = set.property;
            if (property.isImportant(name)) {
                return property.getValue(name);
            }
            ++i;
        }
        i = 0;
        while (i < this.author) {
            set = (PropertyWeightSet)this.properties.get(i);
            property = set.property;
            value = property.getValue(name);
            if (value != null) {
                return value;
            }
            ++i;
        }
        i = this.author;
        while (i < this.user) {
            set = (PropertyWeightSet)this.properties.get(i);
            property = set.property;
            value = property.getValue(name);
            if (value != null) {
                return value;
            }
            ++i;
        }
        i = this.user;
        while (i < this.properties.size()) {
            set = (PropertyWeightSet)this.properties.get(i);
            property = set.property;
            value = property.getValue(name);
            if (value != null) {
                return value;
            }
            ++i;
        }
        if (this.parent != null && definition.isInheritable()) {
            return CSSUtil.getProperty(this.parent).getValue(name);
        }
        return definition.getInitialValue();
    }

    public boolean isImportant(String name) {
        return false;
    }

    public void addProperty(Property property, int origin, int specificity, int position) {
        switch (origin) {
            case 3: {
                this.addProperty(property, specificity, position, 0, this.author);
                ++this.author;
                ++this.user;
                break;
            }
            case 2: {
                this.addProperty(property, specificity, position, this.author, this.user);
                ++this.user;
                break;
            }
            case 1: {
                this.addProperty(property, specificity, position, this.user, this.properties.size());
                break;
            }
        }
    }

    private void addProperty(Property property, int specificity, int position, int start, int end) {
        PropertyWeightSet set = new PropertyWeightSet(property, specificity, position);
        int i = start;
        while (i < end) {
            PropertyWeightSet target = (PropertyWeightSet)this.properties.get(i);
            if (specificity > target.specificity) {
                this.properties.add(i, set);
                return;
            }
            if (specificity == target.specificity && position > target.position) {
                this.properties.add(i, set);
                return;
            }
            ++i;
        }
        this.properties.add(end, set);
    }

    private class PropertyWeightSet {
        private Property property;
        private int specificity;
        private int position;

        public PropertyWeightSet(Property property, int specificity, int position) {
            this.property = property;
            this.specificity = specificity;
            this.position = position;
        }
    }

    private static class RootProperty
    extends AbstractProperty {
        private static final RootProperty SINGLETON = new RootProperty();

        RootProperty() {
        }

        public CSSValue getValue(String name) {
            PropertyDefinition definition = PropertyRegistry.getDefinition(name);
            return definition.getComputedValue(definition.getInitialValue(), this, this);
        }

        public boolean isImportant(String name) {
            return false;
        }
    }
}

