/*
 * Decompiled with CFR 0.152.
 */
package org.trix.cuery.value;

import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.AbstractCSSValue;
import org.trix.cuery.value.CSSLength;
import org.trix.cuery.value.CSSValue;

public abstract class AbstractCSSLength
extends AbstractCSSValue
implements CSSLength {
    public AbstractCSSLength(float length, CSSValue previous) {
        super(previous);
        this.floatValue = length;
        this.stringValue = CSSUtil.displayFloat(this.floatValue);
    }

    public AbstractCSSLength(String length, CSSValue previous) {
        super(previous);
        String unit = this.getDimensionUnitText();
        if (length.endsWith(unit)) {
            length = length.substring(0, length.length() - unit.length());
        }
        this.floatValue = Float.parseFloat(length);
        this.stringValue = CSSUtil.displayFloat(this.floatValue);
    }

    public float getFloatValue() {
        return this.floatValue;
    }

    public String getStringValue() {
        return this.stringValue;
    }

    public String getCssText() {
        return String.valueOf(this.stringValue) + this.getDimensionUnitText();
    }
}

