/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.filter;

import org.w3c.css.sac.Condition;
import org.w3c.css.sac.Selector;
import org.w3c.dom.Element;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: Filter.java,v 1.1 2005/08/04 15:06:42 Teletha Exp $
 */
public interface Filter extends Condition, Selector {

    /**
     * Check whether the target element fills this requirement or not.
     * 
     * @param target A target element to check.
     * @return A result.
     */
    boolean accept(Element target);

    /**
     * Return a selector's specificity.
     * 
     * @return A specificity.
     */
    int getSpecificity();

}
