/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property;

import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

import org.trix.cuery.value.CSSValue;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: SimpleProperty.java,v 1.01 2005/09/08 19:13:00 Teletha Exp $
 */
public class SimpleProperty extends AbstractProperty {

    /** The map of properties. */
    private Map properties = new HashMap(8);

    /**
     * @see org.trix.cuery.property.Property#getValue(java.lang.String)
     */
    public CSSValue getValue(String name) {
        Object[] objects = (Object[]) properties.get(name);

        if (objects == null) {
            return null;
        }
        return (CSSValue) objects[0];
    }

    /**
     * @see org.trix.cuery.property.Property#isImportant(java.lang.String)
     */
    public boolean isImportant(String name) {
        Object[] objects = (Object[]) properties.get(name);

        if (objects == null) {
            return false;
        }
        return ((Boolean) objects[1]).booleanValue();
    }

    /**
     * Add a property.
     * 
     * @param name A property name.
     * @param value A prperty value.
     * @param important A important priority.
     */
    public void setProperty(String name, CSSValue value, boolean important) {
        PropertyDefinition definition = PropertyRegistry.getDefinition(name);

        // user agents must ignore a declaration with an unknown property
        if (definition == null) {
            return;
        }

        // user agents must ignore a declaration with an illegal value
        Map result = definition.parse(value);

        if (result == null) {
            return;
        }

        // store property
        Boolean importance = Boolean.valueOf(important);
        properties.put(name, new Object[] {value, importance});

        // store parsed shorthand property
        Iterator iterator = result.entrySet().iterator();

        while (iterator.hasNext()) {
            Map.Entry entry = (Map.Entry) iterator.next();
            properties.put(entry.getKey(), new Object[] {entry.getValue(), importance});
        }
    }

}
