/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.config;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: DefaultFontConfiguration.java,v 1.0 2005/08/17 5:04:13 Teletha Exp $
 */
public class DefaultFontConfiguration implements FontConfiguration {

    /**
     * @see org.trix.cuery.property.config.FontConfiguration#getDisplayDPI()
     */
    public int getDisplayDPI() {
        return 90;
    }

    /**
     * @see org.trix.cuery.property.config.FontConfiguration#getLineHeightFactor()
     */
    public float getLineHeightFactor() {
        return 1.2f;
    }

    /**
     * @see org.trix.cuery.property.config.FontConfiguration#getMediumFontSize()
     */
    public float getMediumFontSize() {
        return 12;
    }

    /**
     * @see org.trix.cuery.property.config.FontConfiguration#getScalingFactor()
     */
    public float getScalingFactor() {
        return 1.2f;
    }

}
