/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import java.util.Map;

import org.trix.cuery.property.ShorthandPropertyDefinition;
import org.trix.cuery.value.CSSPercentage;
import org.trix.cuery.value.CSSValue;

import org.w3c.css.sac.LexicalUnit;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BackgroundDefinition.java,v 1.0 2005/09/08 22:47:26 Teletha Exp $
 */
public class BackgroundDefinition extends ShorthandPropertyDefinition {

    /**
     * @see org.trix.cuery.property.ShorthandPropertyDefinition#validate(java.util.Map)
     */
    protected Map validate(Map result) {
        CSSValue horizontal = (CSSValue) result.get("background-horizontal-position");

        // check null
        if (horizontal == null) {
            return result;
        }

        CSSValue vertical = (CSSValue) result.get("background-vertical-position");

        // fill ommitted property 'background-vertical-position'
        if (vertical == null) {
            result.put("background-vertical-position", new CSSPercentage(50, null));
            return result;
        }

        // keywords cannot be combined with percentage values or length values
        int flag = 1;

        if (horizontal.getLexicalUnitType() == LexicalUnit.SAC_IDENT) {
            flag = flag ^ 1;
        }

        if (vertical.getLexicalUnitType() == LexicalUnit.SAC_IDENT) {
            flag = flag ^ 1;
        }

        // check flag
        if (flag != 1) {
            return null;
        }
        return result;
    }

}
