/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: EMLength.java,v 1.0 2005/08/09 19:42:18 Teletha Exp $
 */
public class EMLength extends AbstractCSSLength {

    /** The unit. */
    public static final String UNIT = "em";

    /**
     * Create EMLength instance.
     * 
     * @param length A length.
     */
    public EMLength(float length) {
        this(length, null);
    }

    /**
     * Create EMLength instance.
     * 
     * @param length A length.
     */
    public EMLength(String length) {
        this(length, null);
    }

    /**
     * Create EMLength instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public EMLength(float length, CSSValue previous) {
        super(length, previous);
    }

    /**
     * Create EMLength instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public EMLength(String length, CSSValue previous) {
        super(length, previous);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getDimensionUnitText()
     */
    public String getDimensionUnitText() {
        return UNIT;
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_EM;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_EMS;
    }
}
