/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

/**
 * DOCUMENT.
 * 
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: RadianAngle.java,v 1.0 2005/08/09 20:15:12 Teletha Exp $
 */
public class RadianAngle extends AbstractCSSAngle {

    /**
     * Create RadianAngle instance.
     * 
     * @param length A length.
     * @param previous A previous token.
     */
    public RadianAngle(String length, CSSValue previous) {
        super(length, previous);
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getDimensionUnitText()
     */
    public String getDimensionUnitText() {
        return "rad";
    }

    /**
     * @see org.w3c.css.sac.LexicalUnit#getLexicalUnitType()
     */
    public short getLexicalUnitType() {
        return SAC_RADIAN;
    }

    /**
     * @see org.w3c.dom.css.CSSPrimitiveValue#getPrimitiveType()
     */
    public short getPrimitiveType() {
        return CSS_RAD;
    }

}
