/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.property.css2;

import org.trix.cuery.property.SimpleProperty;
import org.trix.cuery.util.CSSUtil;
import org.trix.cuery.value.CSSValue;
import org.trix.cuery.value.Identifier;
import org.trix.cuery.value.PointLength;

import junit.framework.TestCase;


/**
 * DOCUMENT.
 *
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: BorderWidthDefinitionTest.java,v 1.0 2005/08/30 19:40:48 Teletha Exp $
 */
public class BorderWidthDefinitionTest extends TestCase {

    /*
     * Test method for 'org.trix.cuery.property.css2.BorderWidthDefinition.parseValue(CSSValue)'
     */
    public void testParseValue1() {
        CSSValue value = new Identifier("thin", null);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-width", value, false);

        assertEquals("thin", property.getValueAsString("border-top-width"));
        assertEquals("thin", property.getValueAsString("border-bottom-width"));
        assertEquals("thin", property.getValueAsString("border-right-width"));
        assertEquals("thin", property.getValueAsString("border-left-width"));

        assertEquals("thin", CSSUtil.toString(property.getValue("border-width")));
    }
    
    /*
     * Test method for 'org.trix.cuery.property.css2.BorderWidthDefinition.parseValue(CSSValue)'
     */
    public void testParseValue2() {
        CSSValue value = new Identifier("thin", null);
        new Identifier("thick", value);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-width", value, false);

        assertEquals("thin", property.getValueAsString("border-top-width"));
        assertEquals("thin", property.getValueAsString("border-bottom-width"));
        assertEquals("thick", property.getValueAsString("border-right-width"));
        assertEquals("thick", property.getValueAsString("border-left-width"));

        assertEquals("thin thick", CSSUtil.toString(property.getValue("border-width")));
    }
    
    /*
     * Test method for 'org.trix.cuery.property.css2.BorderWidthDefinition.parseValue(CSSValue)'
     */
    public void testParseValue3() {
        CSSValue value = new Identifier("thin", null);
        CSSValue value2 = new PointLength(1, value);
        new Identifier("thick", value2);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-width", value, false);

        assertEquals("thin", property.getValueAsString("border-top-width"));
        assertEquals("thick", property.getValueAsString("border-bottom-width"));
        assertEquals("1", property.getValueAsString("border-right-width"));
        assertEquals("1", property.getValueAsString("border-left-width"));

        assertEquals("thin 1pt thick", CSSUtil.toString(property.getValue("border-width")));
    }
    
    /*
     * Test method for 'org.trix.cuery.property.css2.BorderWidthDefinition.parseValue(CSSValue)'
     */
    public void testParseValue4() {
        CSSValue value = new Identifier("thin", null);
        CSSValue value2 = new PointLength(1, value);
        CSSValue value3 = new PointLength(10, value2);
        new Identifier("thick", value3);

        SimpleProperty property = new SimpleProperty();
        property.setProperty("border-width", value, false);

        assertEquals("thin", property.getValueAsString("border-top-width"));
        assertEquals("10", property.getValueAsString("border-bottom-width"));
        assertEquals("1", property.getValueAsString("border-right-width"));
        assertEquals("thick", property.getValueAsString("border-left-width"));

        assertEquals("thin 1pt 10pt thick", CSSUtil.toString(property.getValue("border-width")));
    }

}
