/*
 * Copyright 2004-2005 The Trix Development Team.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */
package org.trix.cuery.value;

import junit.framework.TestCase;


/**
 * DOCUMENT.
 *
 * @author <a href="mailto:Teletha.T@gmail.com">Teletha Testarossa</a>
 * @version $ Id: CSSColorTest.java,v 1.0 2005/08/10 16:29:54 Teletha Exp $
 */
public class CSSColorTest extends TestCase {
    
    private static CSSColor color = new CSSColor(128, -10, 300, null);

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getStringValue()'
     */
    public void testGetStringValue() {
        assertEquals("#8000ff", color.getStringValue());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getBlue()'
     */
    public void testGetBlue() {
        assertEquals("255", color.getBlue().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getGreen()'
     */
    public void testGetGreen() {
        assertEquals("0", color.getGreen().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getRed()'
     */
    public void testGetRed() {
        assertEquals("128", color.getRed().getCssText());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getRGBValue()'
     */
    public void testGetRGBValue() {
        assertEquals("rgb(128, 0, 255)", color.getRGBValue());
    }

    /*
     * Test method for 'org.trix.cuery.value.CSSColor.getHexValue()'
     */
    public void testGetHexValue() {
        assertEquals("#8000ff", color.getHexValue());
    }

}
