<?xml version="1.0" encoding='shift_jis' standalone='yes' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xml:lang="ja">

<xsl:template match="/">
<HTML>
<HEAD>
<TITLE>CppUnit - Run Summary for All Tests.</TITLE>
</HEAD>
<BODY bgcolor="#E0E0F0">
	<H2 align="center">CppUnit - A Unit testing framework for C++.
		<BR/><U><A HREF="http://cppunit.sourceforge.net/">http://cppunit.sourceforge.net/</A></U>
	</H2>
	<TABLE COLS="4" WIDTH="90%" ALIGN="CENTER">
		<TR> <TD WIDTH="25%"></TD> <TD WIDTH="25%"></TD> <TD WIDTH="25%"></TD> <TD WIDTH="25%"></TD> </TR>
  		<xsl:apply-templates select="/TestRun/*"/>
  	</TABLE>
	<BR/><BR/>
	<HR ALIGN="CENTER" WIDTH="90%" COLOR="RED"/> 
	<H5 ALIGN="CENTER">StyleSheet Produced By <U><A href="http://sourceforge.jp/projects/cuppa/">'cuppa' Project Team</A></U>.</H5>
</BODY>
</HTML>
</xsl:template>

<xsl:template match="FailedTests">
	<TR><TD COLSPAN="3" BGCOLOR="#F0E0F0">FailedTests ...</TD> <TD BGCOLOR="#F0E0F0"> </TD></TR>
   <xsl:choose>
	<xsl:when test="FailedTest">
	  	<xsl:apply-templates select="FailedTest"/>
	</xsl:when>
	<xsl:otherwise>
		<TR>
			<TD BGCOLOR="#E0F0D0" WIDTH="5%"></TD> <TD COLSPAN="2" BGCOLOR="#E0F0D0">...</TD>
			<TD BGCOLOR="#50FF50"> No failed test. </TD>
		</TR>
	</xsl:otherwise>
	</xsl:choose>
<BR/>
</xsl:template>

<xsl:template match="FailedTest">
	<TR>
		<TD BGCOLOR="#E0F0D0" WIDTH="5%"></TD> <TD COLSPAN="2" BGCOLOR="#E0F0D0">Running test <xsl:apply-templates select="Name"/> (id:<xsl:value-of select="@id"/>) ...</TD>
		<TD BGCOLOR="#FF5050"><xsl:apply-templates select="FailureType"/></TD>
	</TR>
	<TR>
		<TD COLSPAN="4" BGCOLOR="#FF9090"> 
			<TABLE WIDTH="100%"> 
				<xsl:apply-templates select="Location"/>
				<TR> <TD WIDTH="15%"> Message </TD> <TD COLSPAN="3" WIDTH="85%" BGCOLOR="#e0eee0"><xsl:apply-templates select="Message"/></TD> </TR>
			</TABLE>
		</TD>
	</TR>
</xsl:template>
<xsl:template match="Name|FailureType|Message"><xsl:value-of select="."/></xsl:template>
<xsl:template match="Location">
	<xsl:if test=".">
			<TR> <TD WIDTH="15%"> File Name </TD> <TD WIDTH="50%" BGCOLOR="#E0EEE0"> <xsl:value-of select="File"/> </TD> <TD WIDTH="20%"> Line Number </TD> <TD WIDTH="10%" BGCOLOR="#E0EEE0"> <xsl:value-of select="Line"/> </TD>  </TR>
	</xsl:if>
</xsl:template>
  
<xsl:template match="SucessfulTests|SuccessfulTests">
	<TR><TD COLSPAN="3" BGCOLOR="#F0E0F0">SuccessfulTests ...</TD> <TD BGCOLOR="#F0E0F0"> </TD></TR>
	<xsl:choose>
	<xsl:when test="Test">
	  	<xsl:apply-templates select="Test"/>
	</xsl:when>
	<xsl:otherwise>
		<TR>
			<TD BGCOLOR="#E0F0D0" WIDTH="5%"></TD> <TD COLSPAN="2" BGCOLOR="#E0F0D0">...</TD>
			<TD BGCOLOR="#FF5050"> No successful test. </TD>
		</TR>
	</xsl:otherwise>
	</xsl:choose>
</xsl:template>

<xsl:template match="Test">
	<TR>
		<TD BGCOLOR="#E0F0D0" WIDTH="5%"></TD> <TD COLSPAN="2" BGCOLOR="#E0F0D0">Running test <xsl:apply-templates select="Name"/> (id:<xsl:value-of select="@id"/>) ...</TD>
		<TD BGCOLOR="#50FF50">Passed</TD>
	</TR>
</xsl:template>

<xsl:template match="Statistics">
	<TR><TD COLSPAN="4">
		<TABLE WIDTH="100%">
			<TR BGCOLOR="SKYBLUE"><TH COLSPAN="4"> Cumulative Summary for Run </TH></TR>
			<TR BGCOLOR="LIGHTBLUE">
				<TH WIDTH="25%" BGCOLOR="#FFFFCo" ALIGN="CENTER"> Tests </TH>
				<TH WIDTH="25%" BGCOLOR="#FFFFCo" ALIGN="CENTER"> FailuresTotal </TH>
				<TH WIDTH="25%" BGCOLOR="#FFFFCo" ALIGN="CENTER"> Errors </TH>
				<TH WIDTH="25%" BGCOLOR="#FFFFCo" ALIGN="CENTER"> Failures </TH>
			</TR>
			<TR>
				<xsl:call-template name="status_value"><xsl:with-param name="status" select="Tests"/></xsl:call-template>
				<xsl:call-template name="status_value"><xsl:with-param name="status" select="FailuresTotal"/></xsl:call-template>
				<xsl:call-template name="status_value"><xsl:with-param name="status" select="Errors"/></xsl:call-template>
				<xsl:call-template name="status_value"><xsl:with-param name="status" select="Failures"/></xsl:call-template>
			</TR>
		</TABLE>
	</TD></TR>
</xsl:template>

<xsl:template name="status_value">
	<xsl:param name="status"/>
	<TD WIDTH="20%" ALIGN="CENTER" BGCOLOR="LIGHTGREEN">
	<xsl:choose>
		<xsl:when test="$status"><xsl:value-of select="$status"/></xsl:when>
		<xsl:otherwise> - NA - </xsl:otherwise>
	</xsl:choose>
	</TD>
</xsl:template>



</xsl:stylesheet>
