/*
 *  CUnit - A Unit testing framework library for C.
 *  Copyright (C) 2001  Anil Kumar
 *  
 *  This library is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU Library General Public
 *  License as published by the Free Software Foundation; either
 *  version 2 of the License, or (at your option) any later version.
 *
 *  This library is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 *  Library General Public License for more details.
 *
 *  You should have received a copy of the GNU Library General Public
 *  License along with this library; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

/*
 *	Contains some generic functions used across CUnit project files.
 *
 *	Created By     : Anil Kumar on 13/Oct/2001
 *	Last Modified  : 13/Oct/2001
 *	Comment        : Moved some of the generic functions definitions 
 *	                 from other files to this one so as to use the 
 *	                 functions consitently. This file is not included
 *	                 in the distribution headers because it is used 
 *	                 internally by CUnit.
 *	EMail          : aksaharan@yahoo.com
 *
 */

#include "CUnit.h"
#include "TestDB.h"
#include "Util.h"
#include "micuni.h"

int compare_strings(const char* szSrc, const char* szDest)
{
	while (*szSrc && *szDest && micuni_toupper(*szSrc) == micuni_toupper(*szDest)) {
		szSrc++;
		szDest++;
	}
		
	return *szSrc - *szDest;
}

void trim(char* szString)
{
	trim_left(szString);
	trim_right(szString);
}

void trim_left(char* szString)
{
	int nOffset = 0;
	char* szSrc = szString;
	char* szDest = szString;
	
/*
	assert(szString);
*/

	/* 
	 * Scan for the spaces in the starting of string.
	 */
	for (; *szSrc; szSrc++, nOffset++) {
		if (!micuni_isspace(*szSrc))
			break;
	}

	for(; nOffset && (*szDest = *szSrc) != 0; szSrc++, szDest++)
		;
	
}

void trim_right(char* szString)
{
	int nLength = 0;
	char* szSrc = szString;
	
/*
	assert(szString);
*/
	nLength = micuni_strlen(szString);
	/*
	 * Scan for specs in the end of string.
	 */
	for (; nLength && micuni_isspace(*(szSrc + nLength - 1)); nLength--)
		;

	*(szSrc + nLength) = '\0';
}

PTestGroup get_group_by_name(const char* szGroupName, PTestRegistry pRegistry)
{
	PTestGroup pGroup = 0;
	PTestGroup pCur = pRegistry->pGroup;

	while (pCur) {

		if (!compare_strings(pCur->pName, szGroupName)) {
			pGroup = pCur;
			break;
		}
		pCur = pCur->pNext;
	}

	return pGroup;
}

PTestCase get_test_by_name(const char* szTestName, PTestGroup pGroup)
{
	PTestCase pTest = 0;
	PTestCase pCur = pGroup->pTestCase;

	while (pCur) {
		
		if (!compare_strings(pCur->pName, szTestName)) {
			pTest = pCur;
			break;
		}
		pCur = pCur->pNext;
	}

	return pTest;
}
