#include <micuni.h>

extern void* malloc(unsigned);
extern int   putchar(int);
extern void  abort(void);

typedef long Align;

union header {
  struct {
    union header* ptr;
    unsigned size;
  } s;
  Align x;
};

typedef union header Header;

static Header base;
static Header* freep;

/* 
 * ȂƂ sizeof(Header) * NALLOC [byte] ܂Ƃ߂ĊmۂB
 */
#define NALLOC 128

char* micuni_sbrk(int n) {
  char* p;
  p = (char*)malloc(n); /* <---------------- Ńm ------- */
  if ( p == 0 ) return (char*)-1;
  return p;
}

static Header* micuni_morecore(unsigned nu) {
  char* cp;
  Header* up;
  if ( nu < NALLOC )
     nu = NALLOC;
  cp = micuni_sbrk(nu * sizeof(Header));
  if ( cp == (char*)-1 )
    return 0;
  up = (Header*)cp;
  up->s.size = nu;
  micuni_free((void*)(up+1));
  return freep;
}

void* micuni_malloc(unsigned int nbytes) {
  Header* p;
  Header* prevp;
  unsigned nunits;

  nunits = (nbytes+sizeof(Header)-1)/sizeof(Header) + 1;
  if ( ( prevp = freep) == 0 ) {
    base.s.ptr = freep = prevp = &base;
    base.s.size = 0;
  }
  for ( p = prevp->s.ptr; ; prevp = p, p = p->s.ptr) {
    if ( p->s.size >= nunits ) {
      if ( p->s.size == nunits )
        prevp->s.ptr = p->s.ptr;
      else {
        p->s.size -= nunits;
        p += p->s.size;
        p->s.size = nunits;
      }
      freep = prevp;
      return (void*)(p+1);
    }
    if ( p == freep )
      if ( (p = micuni_morecore(nunits)) == 0 ) 
        return 0;
  }
}

/* --------------------
 * Ag܂킷
 * --------------------
 */
void  micuni_free(void* ap) {
  Header* bp;
  Header* p;
  bp = (Header*)ap - 1;
  for ( p = freep; !(bp > p && bp < p->s.ptr); p = p->s.ptr)
    if ( p >= p->s.ptr && (bp > p || bp < p->s.ptr ) )
      break;
  if ( bp + bp->s.size == p->s.ptr ) {
    bp->s.size += p->s.ptr->s.size;
    bp->s.ptr = p->s.ptr->s.ptr;
  } else
    bp->s.ptr = p->s.ptr;
  if ( p + p->s.size == bp ) {
    p->s.size += bp->s.size;
    p->s.ptr = bp->s.ptr;
  } else
    p->s.ptr = bp;
  freep = p;
}

void  micuni_putchar(char ch) {
  putchar(ch);
}

void micuni_putln(void) {
  putchar('\n');
}

void  micuni_abort(void) {
  abort();
}

