#ifndef COCUPPA_CURIE_HPP__
#define COCUPPA_CURIE_HPP__

#ifdef _MSC_VER
#  pragma warning( disable : 4786 )
#endif


#include <string>    // string
#include <vector>    // vector



namespace curie {

  /** my exception*/
  class error {
	public:
		error(const std::string &msg) : msg_(msg){}
	private:
		std::string msg_;
  };

  /**classes for contents from Doxygen */
  typedef std::vector<std::string> ParamTypes;
  class Method {
  public:
    explicit Method() : const_(false), isPureVirtual_(false){}
    std::string name_;
    bool   const_;
    bool isPureVirtual_;
  };
  typedef std::vector<Method> Methods;

  struct ClassDef {
    std::string name_;
    std::string includeName_;
    Methods methods_;

    bool hasPureVirtual() const;
  };
  typedef std::vector<ClassDef> ClassDefs;


  /** classes for test-declaration */
  struct TestMethod {
    explicit TestMethod(const std::string &name, const bool pureVirtual = false)
      : pureVirtual_(pureVirtual), name_(name)  {}
    bool pureVirtual_;
    std::string name_;
  };

  typedef std::vector<TestMethod> TestMethods;
  struct TestDef {
    TestDef()  : hasPureVirtual_(false) {}
    TestMethods testMethods_;
    std::string testName_;
    std::string includeName_;
    bool        hasPureVirtual_;
  };
  typedef std::vector<TestDef> TestDefs;


  /** Doxygen XML. */
  int parseFile(const std::string &filename, ClassDefs &defs);

  /** Test */
  void createTestNames(const ClassDefs &classes, const std::string &prefix, TestDefs &tests);


  /** Curie body */
  class Curie {
    typedef std::vector<std::string> Files;

    bool   forceEnabled_;
    bool   relative_;
    std::string mainName_;
    std::string stripPath_;

    TestDefs testDefs_;
    ClassDefs classDefs_;
    Files files_;
  public:
    Curie() : forceEnabled_(false), relative_(false){}

    void addFile(const std::string &fileName);
    void outputMain(std::ostream &ostm) const;
    void outputSkeletons(std::ostream &ostm) const;
    void outputMakeArgs(std::ostream &ostm) const;

    // Setters
    void setMainName(const std::string &name) { mainName_ = name; }
    void setForceEnabled(bool b) { forceEnabled_ = b; }
    void setRelative(bool b) { relative_ = b; }
    void setStripPath(const std::string &str);

    int createTestDefs();

  private:
    void checkClassDefs();
    std::string createRelativePath(const std::string &path);
    static std::string getcwd();
  };
}



#endif


