//
//  Parser for Doxygen XML files.
//
#include "curie.h"

#include <iostream>

// Xercesc includes

#include <xercesc/util/XercesDefs.hpp>

#if defined(XERCES_VERSION_MAJOR) // For Xerces-C++-2.0.0.
# include <xercesc/dom/deprecated/DOM.hpp>
# include <xercesc/dom/deprecated/DOMParser.hpp>
#else // For Xerces-C++ 1.7.0
#  include <xercesc/parsers/DOMParser.hpp>
#  include <xercesc/dom/DOM_NamedNodeMap.hpp>
#endif

namespace {
  using namespace curie;
  typedef std::vector<DOM_Node> Nodes;

  // concatenate text-nodes under the node
  std::string getNodeText(DOM_Node &node) {
    std::string text;

    DOM_Node child = node.getFirstChild();
    if (child == NULL)
      return "";

    for (; child != NULL; child = child.getNextSibling()){
      if (child.getNodeType() == DOM_Node::TEXT_NODE)
	text += child.getNodeValue().transcode();
      else
	text += getNodeText(child);
    }
    return text;
  }

  //
  // m[h̒o֐
  //

  /** ǂPredicate*/
  struct NullPred {
    bool operator()(DOM_Node &node) const {
      return true;
    }
  };

  /**Ow肵Ďqm[h擾
   *PredŎw肵ƃm[hvm[h𒊏oB
   */
  template<class Pred>
		void extractChildNodes(DOM_Node &top, const std::string &name,
			 const Pred &pred, Nodes &extracted){

    if (top.getNodeType() != DOM_Node::ELEMENT_NODE)
      throw error("DOM_Node is not an element.");

    for (DOM_Node child = top.getFirstChild();
	 child != NULL;
	 child = child.getNextSibling()){
      if (child.getNodeName().equals(DOMString(name.c_str())) && pred(child) ) {
	extracted.push_back(child);
      }
    }
  }

  /**Ow肵Ďqm[h𒊏o
   * @exception internal_error ̎qm[htꍇAB
   */
  DOM_Node extractSingleChildNode(DOM_Node &origin, const std::string &name){
    Nodes nodes;
    extractChildNodes(origin, name, NullPred(), nodes);
    if (nodes.size() != 1) {
      throw error("Just one node expected.");// Just one node should be found, but not.
    }
    return *nodes.begin();
  }


  /**Agr[g̏w.
     @param attrName Agr[g
     @param value Agr[g̒l
  */
  class AttrPred {
  public:
    AttrPred(const std::string &attrName, const std::string &value){
      attrName_ = attrName;
      value_ = value;
    }
    bool operator()(DOM_Node &node) const {
      DOM_NamedNodeMap nmap = node.getAttributes();
      if (nmap == NULL)
	return false;
      DOM_Node attrNode = nmap.getNamedItem(DOMString(attrName_.c_str()));
      std::string text = getNodeText(attrNode);
      return text ==  value_;
    }
  private:
    std::string attrName_;
    std::string value_;
  };

  /**Ow肵m[hɂeLXg擾B */
	std::string getNamedNodeText(DOM_Node &node, const std::string &tagName){
    DOM_Node namedNode = extractSingleChildNode(node, tagName);
    return getNodeText(namedNode);
  }

  /**Ow肵Agr[g̃eLXgl擾B */
  std::string getNamedAttributeText(DOM_Node &node, const std::string &attrName){
    DOM_NamedNodeMap nmap = node.getAttributes();
    DOM_Node attrNode = nmap.getNamedItem(DOMString(attrName.c_str()));
    return attrNode.getNodeValue().transcode();
  }

}


namespace curie {

  // Filẽp[X
  // DOM쐬 -> ClassDefs̍\z
  int parseFile(const std::string &filename, ClassDefs &defs){

    DOMParser parser;
    try {
      parser.parse(filename.c_str());
    }
    catch ( ... ) {
      std::cerr << "Failed to parse a file, " << filename << "." << std::endl;
      return 1;
    }

    try {

      Nodes clsdefNodes;
      DOM_Document doc = parser.getDocument();
      DOM_Element elm = doc.getDocumentElement(); // doxygenm[h
      
      // compounddef[@kind="class"]
      extractChildNodes(elm, "compounddef", AttrPred("kind", "class"), clsdefNodes);
      // compounddef[@kind="struct"]
      extractChildNodes(elm, "compounddef", AttrPred("kind", "struct"), clsdefNodes);
      
      for (Nodes::iterator it = clsdefNodes.begin();
	   it != clsdefNodes.end(); ++it){
	Nodes secdefNodes;
	ClassDef def;
	
	// compounddef/compoundname NX̖O擾
	def.name_ = getNamedNodeText(*it, "compoundname");
	
	// compounddef/location/@file CN[ht@CpX擾
	DOM_Node locNode = extractSingleChildNode(*it, "location");
	def.includeName_ = getNamedAttributeText(locNode, "file");
	
	// compoundeef/sectiondef[@kind="public-func"]  publicȃ\bh𒊏o
	extractChildNodes(*it, "sectiondef", AttrPred("kind", "public-func"), secdefNodes);
	
	for (Nodes::iterator secdefit = secdefNodes.begin();
	     secdefit != secdefNodes.end(); ++secdefit) {
	  
	  Nodes memdefNodes;
	  // compounddef/sectiondef/memberdef[@kind="function"]
	  extractChildNodes(*secdefit, "memberdef", AttrPred("kind", "function"), memdefNodes);

	  for (Nodes::iterator memdefit = memdefNodes.begin(); memdefit != memdefNodes.end();
	       ++memdefit){
	    Method method;
	    // compounddef/sectiondef/memberdef/name
	    method.name_ = getNamedNodeText(*memdefit, "name");
	    
	    // compounddef/sectiondef/memberdef/@virt
			std::string attrValue = getNamedAttributeText(*memdefit, "virt");
	    method.isPureVirtual_ = (attrValue == "pure-virtual");
	    
	    // compounddef/sectiondef/memberdef/@const
	    attrValue = getNamedAttributeText(*memdefit, "const");
	    method.const_ =  (attrValue == "yes");
	    
	    def.methods_.push_back(method);
	  }
	}
	defs.push_back(def);
      }
    }
    catch ( ... ){
      std::cerr << "Parse imcomplete, or wrong document." << std::endl;
      return 1;
    }
    return 0;
  }
}
