#ifndef cuppa_cocuppa_h
#define cuppa_cocuppa_h

#include <iostream>  // ostream
#include <string>    // string
#include <vector>    // vector
#include <utility>   // pair

// fuffix for decl/impl
#define DECL_SUFFIX ".h"
#define IMPL_SUFFIX ".cpp"
// XML encoding
#define XML_ENCODING "shift_jis"

namespace cuppa {

class cocuppa {

  typedef std::pair<std::string,bool> method_type;
  typedef std::pair<std::string,bool> inc_type;
  typedef std::vector<method_type>    cases_type;
  typedef std::vector<inc_type>       incs_type;

  cases_type  cases;
  incs_type   incs;
  std::string suite;
  std::string ns;
  std::string super;
  bool        standalone;
  bool        noregist;
  bool        prefix;

public:
  cocuppa() {
    set_standalone(true);
    set_noregist(false);
    set_prefix(false);
  }
  void        make_suite_decl(std::ostream& strm) const;
  void        make_suite_impl(std::ostream& strm) const;
  void        add_include(const std::string& inc, bool system=false) 
    { incs.push_back(inc_type(inc,system)); }
  void        set_namespace(const std::string& n) { ns = n; }
  void        set_standalone(bool b)              { standalone = b; }
  bool        get_standalone() const              { return standalone; }
  void        set_suite(const std::string& s)     { suite = s; }
  std::string get_suite() const                   { return suite; }
  void        add_case(const std::string& method, bool inl)
    { cases.push_back(method_type(method,inl)); }
  void        set_noregist(bool nr)               { noregist = nr; }
  void        set_prefix(bool p)                  { prefix = p; }
  void        set_super(const std::string& s)     { super = s; }
  static void make_main(std::ostream& strm);
};

}

#endif
