#ifndef cuppa_tokenizer_h
#define cuppa_tokenizer_h

#include <iostream>
#include <string>

namespace cuppa {

template<class E =char>
class tokenizer {
public:
  typedef std::basic_string<E> string_type;
  typedef typename string_type::size_type   size_type;

  explicit tokenizer(const string_type& str = string_type())
    : str_(str), off_(0) {}

  void set_string(const string_type& str) { str_ = str; }
  bool has_more_token(const string_type& delim) const;
  string_type next_token(const string_type& delim);
  bool next_token(const string_type& delim, string_type& result)
    { result = next_token(delim); return !result.empty(); }
  void rewind() { off_ = 0; }

private:
  string_type str_;
  size_type   off_;
};

template<class E>
inline bool
tokenizer<E>::has_more_token(const string_type& delim) const {
  return off_ == string_type::npos ?
    false : str_.find_first_not_of(delim, off_) != string_type::npos;
}

template<class E>
inline typename tokenizer<E>::string_type
tokenizer<E>::next_token(const string_type& delim) {
  size_type first = str_.find_first_not_of(delim, off_);
  if ( first == string_type::npos ) {
    return string_type();
  }
  off_  = str_.find_first_of(delim, first);
  return str_.substr(first, off_ == string_type::npos ? off_ : off_ - first);
}

}

#endif
