/*! @file
	File     : mksrclist.cpp
	@brief   : make source-list of cppunit
	@author  : ahiru (http://www3.to/ahirus)
	@date $Date: 2002/08/27 08:38:42 $
	$Revision: 1.3 $
	@note : 
*/

static char rcsid[]="$Id: mksrclist.cpp,v 1.3 2002/08/27 08:38:42 smorino Exp $";

#pragma warning(disable:4786)
#include <iostream>
#include <vector>
#include <string>
#include <dir>
#include <algorithm>

using namespace std;

void usage(char * fn)
{
	cerr << fn << " " << rcsid << endl;
	cerr << "usage : " << fn << " [-kmnrs] input [output]\n";
	cerr << "             option                 description\n";
}

typedef std::vector<std::string> strarg;
bool getflist(strarg & flist,const char * path)
{
	ffblk fh;
	int done=findfirst(path,&fh,0);
	while(!done) {
		std::string cpp=fh.ff_name;
		cpp.replace(cpp.rfind('.'),4,".obj");
		flist.push_back(cpp);
		done = findnext(&fh);
	}
	return true;
}

template <class T=std::string>
struct print
{
	print(ostream & os,char * pad,char * tag,char * dir)
		: os_(os) {chgset(pad,tag,dir);}
	void start() {os_<<tag_<<"= \\\n";}
	void end() {os_<<std::endl;}
	void chgset(char * pad,char * tag,char * dir) {
		pad_=pad,tag_=tag,dir_=dir;
	}
	void operator ()(T & obj) {
		os_<< pad_ << "$(" << dir_ << ")\\" << obj << " \\\n";
	}
	std::ostream & os_;
	char * pad_;
	char * tag_;
	char * dir_;
};

int main(int argc,char **argv)
{
	char *fname;
	char *cmdname;

	cmdname=argv[0];
	if(argc>1) {
		argv++;
		do {
			if((*argv)[0]=='-') {
				switch((*argv)[1]) {
				case 'x':
					break;
				case '-' :
				default:
					usage(cmdname);
					return -1;
				}
			} else break;
			argv++;
		} while (*argv!=NULL);
	} else {
		usage(cmdname);
		return -1;
	} 
	fname = argv[0];

	vector<string> flist;
	getflist(flist,fname);

	/// static-library 
	print<> prn(cout," ","REL_OBJS","RELEASE_OBJDIR_static");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	/// static-library for debug
	prn.chgset(" ","DEB_OBJS","DEBUG_OBJDIR_static");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	/// dynamic-library
	prn.chgset(" ","REL_DLL_OBJS","RELEASE_OBJDIR_dll");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	/// dynamic-library for debug
	prn.chgset(" ","DEB_DLL_OBJS","DEBUG_OBJDIR_dll");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	/// objects for making lib
	prn.chgset(" +","REL_LIBCMD_OBJS","RELEASE_OBJDIR_static");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	/// objects for making lib
	prn.chgset(" +","DEB_LIBCMD_OBJS","DEBUG_OBJDIR_static");
	prn.start();
	for_each(flist.begin(),flist.end(),prn);
	prn.end();
	return 0;
}
