# File     : makefile
# Function : makefile for Borland C++
# Author   : ahiru (http://www3.to/ahirus)
# $Date: 2002/08/21 01:03:09 $
# $Revision: 1.1 $

## BC++ install dir.
BCB=c:\bcc55
PROJECT=StdInParse
PRO_DIR=$(XERCES)\samples\$(PROJECT)
XERCES_INCLUDE=..\..\..\..\..\src
XERCES_LIB_DIR=$(XERCES)\Build\Win32\BCB6
XERCES_LIB=$(XERCES_LIB_DIR)\XercesLib.lib

DEF=PROJ_SAXCOUNT;WIN32;PLATFORM_WIN32
## directory settings
ROOT=$(PRO_DIR)
## \[XfBNĝݑΉ
##   fBNgɂ܂ꍇAsKvB
SRCDIR=$(ROOT)
INCDIR=$(ROOT);$(XERCES_INCLUDE)
# }`XbhΉɂꍇ 1
MULTI=1
WIN=0
USEDLL=0
LIBNAME=$(XERCES_LIB)

# o͂^[Qbg`
#   EXE,LIB,DLL
TARGET_KIND=exe

#############################################################
!if $(TARGET_KIND)==exe
SUBMAKE=makeexe.mak
!elif $(TARGET_KIND)==lib
SUBMAKE=makelib.mak
!elif $(TARGET_KIND)==dll
SUBMAKE=makedll.mak
!else
!error TARGET_KIND illegal type-string.. (<exe> or <lib> or <dll>)
!endif

## tool target
TOOL_DIR=..
TOOL=$(TOOL_DIR)\mksrclist.exe

## directory settings
CURRENT=source.mak

MAKEPARAM = BCB="$(BCB)" ROOT="$(ROOT)" USEDLL="$(USEDLL)" MULTI="$(MULTI)" PRJ_NAME="$(PROJECT)" PRJ_SRC="$(SRCDIR)" PRJ_INC="$(INCDIR)" WIN="$(WIN)" USRDEF="$(DEF)"
!if "$(LIBNAME)"!=""
MAKEPARAM = $(MAKEPARAM) LIBS="$(LIBNAME)"
!endif
!if "$(LIBDIR)"!=""
MAKEPARAM = $(MAKEPARAM) PRJ_LIB="$(LIBDIR)"
!endif

srclist: $(CURRENT)
all: $(PROJECT)

$(CURRENT):
	$(TOOL) -o 0 -c obj $(SRCDIR)\*.cpp > $<
	$(TOOL) -o 1 -c res $(SRCDIR)\*.rc >> $<

$(PROJECT): srclist
	-make -a -f $(SUBMAKE) $(MAKEPARAM)

debug: srclist
	-make -a -f $(SUBMAKE) $(MAKEPARAM) debug

release: srclist
	-make -a -K -p -f $(SUBMAKE) $(MAKEPARAM) release

cleandll:
	-make -f $(SUBMAKE) cleandll

cleanlib:
	-make -f $(SUBMAKE) cleanlib

clean:
	-make -f $(SUBMAKE) clean
	-if exist $(CURRENT) (del /q $(CURRENT))

