require 'test/unit/assertions'

module Umigame
  class SourceCode
    include Test::Unit::Assertions
  
    attr_reader :class_begin, :class_end, :method, :include
    attr_writer :has_suite
    attr_accessor :line, :class_name
    
    def initialize
      @class_begin = []
      @class_end = []
      @include_index = {}
      @include = []
      @method_index = {}
      @method = []
      @has_suite = true
    end
    
    def add_new_method(methodname)
      add_method(methodname, !has_suite?)
    end
    
    def add_method(method, prefix)
      method.prefix = prefix
      @method.push method
      @method_index[method.name] = method
    end
    
    def get_method(index)
      @method_index[index]
    end
    
    def add_include(file)
      flunk("duplicate include file '#{file}'") if include?(file)
      @include.push file
      @include_index[file] = true
    end
    
    def include?(index)
      @include_index[index]
    end
    
    def has_suite?
      @has_suite
    end
    
    def print
      # fook method
    end
  end
end
