/*
 * Aipo is a groupware program developed by Aimluck,Inc.
 * http://aipostyle.com/
 * 
 * Copyright(C) 2009 avanza Co.,Ltd. All rights reserved.
 * http://www.avnz.co.jp/
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program. If not, see <http://www.gnu.org/licenses/>.
 */
package com.aimluck.eip.circulation;

import java.util.ArrayList;

import com.aimluck.commons.field.ALNumberField;
import com.aimluck.commons.field.ALStringField;
import com.aimluck.eip.common.ALData;
import com.aimluck.eip.util.ALCommonUtils;
import com.aimluck.eip.util.ALEipUtils;

/**
 * CirculationのResultDataです。 <BR>
 * 
 */
public class CirculationResultData implements ALData {

  /** 回覧板 ID */
  private ALNumberField request_id;

  /** 回覧板名 */
  private ALStringField request_name;
  
  /** カテゴリID */
  protected ALNumberField category_id;

  /** カテゴリ名 */
  protected ALStringField category_name;

  /** メモ */
  private ALStringField note;
  
  /** 重要度 */
  protected ALNumberField priority;

  /** 重要度画像名 */
  protected ALStringField priority_image;

  /** 重要度（文字列） */
  protected ALStringField priority_string;
  
  /** 進捗度 */
  private ALStringField progress_string;
  
  /** 登録日 */
  private ALStringField create_date;

  /** 更新日 */
  private ALStringField update_date;

  /** 締切日 */
  private ALStringField limit_date;
  
  /** 作成者 */
  protected ALStringField create_user;
  
  /** オーナ ID */
  private ALNumberField owner_id;
  
  /** 添付ファイルリスト */
  private ArrayList attachmentFileList = null;
  
  /**
   * 期限状態（期限前/期限当日/期限後）． <br>
   * クラス ToDoUtils の変数 LIMIT_STATE_BEFORE，LIMIT_STATE_TODAY，LIMIT_STATE_AFTER
   * を参照．
   */
  private ALNumberField limit_state;
  
  /**
   * 
   * @see com.aimluck.eip.common.ALData#initField()
   */
  public void initField() {
    request_id = new ALNumberField();
    request_name = new ALStringField();
    category_id = new ALNumberField();
    category_name = new ALStringField();
    note = new ALStringField();
    note.setTrim(false);
    priority = new ALNumberField();
    priority_image = new ALStringField();
    priority_string = new ALStringField();
    create_date = new ALStringField();
    update_date = new ALStringField();
    limit_date = new ALStringField();
    attachmentFileList = new ArrayList();
    progress_string = new ALStringField();
    create_user = new ALStringField();
    owner_id = new ALNumberField();
    limit_state = new ALNumberField();
  }

  /**
   * @return
   */
  public ALNumberField getRequestId() {
    return request_id;
  }
  
  /**
   * @param i
   */
  public void setRequestId(long i) {
    request_id.setValue(i);
  }

  /**
   * @return
   */
  public String getRequestName() {
    return ALCommonUtils.replaceToAutoCR(request_name.toString());
  }
  
  /**
   * @param string
   */
  public void setRequestName(String string) {
    request_name.setValue(string);
  }
  
  /**
   * @return
   */
  public ALNumberField getCategoryId() {
    return category_id;
  }
  
  /**
   * @param i
   */
  public void setCategoryId(long i) {
    category_id.setValue(i);
  }

  /**
   * @return
   */
  public String getCategoryName() {
    return ALCommonUtils.replaceToAutoCR(category_name.toString());
  }


  /**
   * @param i
   */
  public void setCategoryName(String string) {
    category_name.setValue(string);
  }
  
  /**
   * @param i
   */
  public void setPriority(int i) {
    priority.setValue(i);
  }
  
  /**
   * @param string
   */
  public void setPriorityImage(String string) {
    priority_image.setValue(string);
  }

  /**
   * @param string
   */
  public void setPriorityString(String string) {
    priority_string.setValue(string);
  }
  
  /**
   * @return
   */
  public ALStringField getPriorityString() {
    return priority_string;
  }

  /**
   * @return
   */
  public ALStringField getPriorityImage() {
    return priority_image;
  }

  /**
   * @return
   */
  public String getNote() {
    return ALEipUtils.getMessageList(note.getValue());
  }

  /**
   * @param string
   */
  public void setNote(String string) {
    note.setValue(string);
  }


  /**
   * @return
   */
  public ALStringField getCreateDate() {
    return create_date;
  }

  /**
   * @return
   */
  public ALStringField getUpdateDate() {
    return update_date;
  }
  
  /**
   * @return
   */
  public ALStringField getLimitDate() {
    return limit_date;
  }

  /**
   * @param string
   */
  public void setCreateDate(String string) {
    create_date.setValue(string);
  }

  /**
   * @param string
   */
  public void setUpdateDate(String string) {
    update_date.setValue(string);
  }
  
  /**
   * @param string
   */
  public void setLimitDate(String string) {
    limit_date.setValue(string);
  }
  
  /**
   * @param list
   */
  public void setAttachmentFiles(ArrayList list) {
    attachmentFileList = list;
  }
  
  /**
   * @return list
   */
  public ArrayList getAttachmentFileList() {
    return attachmentFileList;
  }

  public ALStringField getProgressString() {
    return progress_string;
  }

  public void setProgressString(String p) {
    progress_string.setValue(p);
  }

  public ALStringField getCreateUser() {
    return create_user;
  }

  public void setCreateUser(String p) {
    create_user.setValue(p);
  }

  public ALNumberField getOwnerId() {
    return owner_id;
  }

  public void setOwnerId(long i) {
    owner_id.setValue(i);
  }

  public ALNumberField getLimitState() {
    return limit_state;
  }

  public void setLimitState(int value) {
    limit_state.setValue(value);
  }
}
