/* ====================================================================
 * The Apache Software License, Version 1.1
 *
 * Copyright (c) 2000-2001 The Apache Software Foundation.  All rights
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Apache" and "Apache Software Foundation" and
 *     "Apache Jetspeed" must not be used to endorse or promote products
 *    derived from this software without prior written permission. For
 *    written permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache" or
 *    "Apache Jetspeed", nor may "Apache" appear in their name, without
 *    prior written permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */

package org.apache.jetspeed.portlet;

import java.util.AbstractList;
import java.util.LinkedList;

/**
 ** Instances of the <CODE>Capability</CODE> class correspond to particular
 ** properties which can be assigned to the client devices.
 **
 ** <P>
 ** The class has only a private constructor, so that it is not possible
 ** to dynamically create objects of this class from outside the class. A set
 ** of predefined isntances (ie. capabilities) is provided.
 **
 ** @see   Client
 **
 ** @author   <A HREF="mailto:tboehme@us.ibm.com">Thomas F. Boehme</A>
 **/

public class Capability
{
    private AbstractList impliedCapabilities = new LinkedList ();

    private static AbstractList capabilities = new LinkedList ();

    public final static Capability HTML_JAVA     = new Capability ("HTML Java", 0);
    public final static Capability HTML_JAVA_1_0 = new Capability ("HMTL Java 1.0", 1);
    public final static Capability HTML_JAVA_1_1 = new Capability ("HTML Java 1.1", 2);
    public final static Capability HTML_JAVA_1_2 = new Capability ("HTML Java 1.2", 3);

    public final static Capability HTML_JAVASCRIPT     = new Capability ("HTML JavaScript", 4);
    public final static Capability HTML_JAVASCRIPT_1_0 = new Capability ("HTML JavaScript 1.0", 5);
    public final static Capability HTML_JAVASCRIPT_1_1 = new Capability ("HTML JavaScript 1.1", 6);
    public final static Capability HTML_JAVASCRIPT_1_2 = new Capability ("HTML JavaScript 1.2", 7);

    public final static Capability HTML_TABLE        = new Capability ("HTML Table Support", 8);
    public final static Capability HTML_NESTED_TABLE = new Capability ("HTML Nested Table Support", 9);

    public final static Capability HTML_FORM  = new Capability ("HTML Forms Support", 10);

    public final static Capability HTML_FRAME = new Capability ("HTML Frames Support", 11);

    public final static Capability HTML_IMAGE = new Capability ("HTML Images Support", 12);

    public final static Capability HTML_ACTIVE_X = new Capability ("HTML Active X", 13);

    public final static Capability HTML_CSS1 = new Capability ("HTML CSS1 Support", 14);
    public final static Capability HTML_CSS2 = new Capability ("HTML CSS2 Support", 15);
    public final static Capability HTML_CSSP = new Capability ("HTML CSSP Support", 16);

    public final static Capability WML_TABLE = new Capability ("WML Table Support", 17);

    public final static Capability HTTP_COOKIE = new Capability ("HTTP Cookie Support", 18);

    static
    {
        HTML_JAVASCRIPT_1_0.implies (HTML_JAVASCRIPT);
        HTML_JAVASCRIPT_1_1.implies (HTML_JAVASCRIPT);
        HTML_JAVASCRIPT_1_2.implies (HTML_JAVASCRIPT);

        HTML_JAVA_1_0.implies (HTML_JAVA);
        HTML_JAVA_1_1.implies (HTML_JAVA);
        HTML_JAVA_1_2.implies (HTML_JAVA);

        // need many more...
    }

    /**
     ** Returns a hash code for this capability.
     **
     ** @return   the hash code
     **/

    public int hashCode ()
    {
        return (value);
    }

    /**
     ** Returns whether this and the given object represent the same
     ** capability.
     **
     ** @param   object
     **          the object to compare with
     **
     ** @return   <CODE>true</CODE> if the objects represent the same capability, <BR>
     **           <CODE>false</CODE> otherwise
     **/

    public boolean equals (Object object)
    {
        boolean result = false;

        if (object instanceof Capability)
        {
            result = (this.getClass () == object.getClass () &&
                      this.getValue () == ((Capability) object).getValue ());
        }

        return (result);
    }

    /**
     ** Returns the capability as a displayable string.
     **
     ** @return   the displayable string
     **/

    public String toString ()
    {
        return (identifier);
    }

    /**
     ** Returns the identifier of this capability.
     **
     ** @return   the capability
     **/

    public String getIdentifier ()
    {
        return (identifier);
    }

    /**
     ** Returns the integer value of this capability.
     **
     ** @return   the integer value
     **/

    protected int getValue ()
    {
        return (value);
    }

    private String identifier;

    private int value;

    /**
     ** Constructs a capability.
     **
     ** @param   identifier
     **          the identifier of the capability
     ** @param   value
     **          the integer value of the capability
     **/

    private Capability (String identifier, int value)
    {
        this.identifier = identifier;
        this.value      = value;

        capabilities.add (this);
    }

    /**
     ** Registers an implied capability with this capability.
     **
     ** @param   capability
     **          the implied capability
     **/

    private void implies (Capability capability)
    {
        impliedCapabilities.add (capability);
    }
}

